unit UF_Scores;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms, Dialogs, ExtCtrls, StdCtrls, Math,
  UFrm_Score;

const NOM1 = 1;
      NOM2 = 2;

type
  TF_Scores = class(TForm)
    Image1: TImage;
    Image2: TImage;
    Lab_Dizaines: TLabel;
    Lab_Unites: TLabel;
    procedure FormCreate(Sender: TObject);
  private
    sNomEquipe: string;
    iScore: integer;

    procedure UpdateScore();

  public
    procedure Set_Nom_Equipe(sNomEq: string; Couleur: TColor);
    procedure Inc_Score();
    procedure Dec_Score();
    procedure Set_Score(iNewScore: integer);
  end;

implementation

{$R *.dfm}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


procedure TF_Scores.FormCreate(Sender: TObject);
begin
  iScore := 0;
end;


//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


procedure TF_Scores.Set_Nom_Equipe(sNomEq: string; Couleur: TColor);
begin
  sNomEquipe := sNomEq;
  Lab_Dizaines.Font.Color := Couleur;
  Lab_Unites.Font.Color := Couleur;
end;


//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


procedure TF_Scores.UpdateScore();
var sScore: string;
begin
  sScore := IntToStr(iScore);

  Lab_Unites.Caption := sScore[length(sScore)];

  if (iScore < 10) then Lab_Dizaines.Caption := '0'
  else Lab_Dizaines.Caption := sScore[length(sScore)-1];
end;


//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


procedure TF_Scores.Inc_Score();
begin
  iScore := Min(iScore + 1, 99);
  UpdateScore();
end;


//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


procedure TF_Scores.Dec_Score();
begin
  iScore := Max(iScore - 1, 0);
  UpdateScore();
end;


//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


procedure TF_Scores.Set_Score(iNewScore: integer);
begin
  iScore := iNewScore;
  UpdateScore();
end;


//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


end.
