unit UF_Main;

interface

uses
      Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms, Dialogs, Menus, jpeg, ExtCtrls
      , StdCtrls, Buttons, pngimage, Math, OleCtrls, WMPLib_TLB, StrUtils, OleServer
      , UF_Scores
      ;

const NUM_EQUIPE_KETCHUP = 0;
const NUM_EQUIPE_MAYO = 1;
const NOM_EQUIPE_KETCHUP = 'Ketchup';
const NOM_EQUIPE_MAYO = 'Mayo';
const NOM_EQUIPE1 = NOM_EQUIPE_KETCHUP;
const NOM_EQUIPE2 = NOM_EQUIPE_MAYO;

var NOM_Fichier_SON_BUZZER1 : string;
var NOM_Fichier_SON_BUZZER2 : string;

type
  TF_Main = class(TForm)
    PopupMenu: TPopupMenu;
    Quitter: TMenuItem;
    RglagesScores: TMenuItem;
    Accueil: TMenuItem;
    Scores: TMenuItem;
    Nuggets: TMenuItem;
    Sel_ou_Poivre: TMenuItem;
    Menus: TMenuItem;
    Addition: TMenuItem;
    BurgerDeLaMort: TMenuItem;
    Regles: TMenuItem;
    Toss: TMenuItem;
    N1: TMenuItem;
    CommandesduJour1: TMenuItem;
    Book_Main: TNotebook;
    Image2: TImage;
    Pan_Score_Mayo: TPanel;
    Img_Score_Mayo: TImage;
    Pan_Score_Ketchup: TPanel;
    Img_Score_Ketchup: TImage;
    Image1: TImage;
    Label4: TLabel;
    Pan_Score_Ketchup2: TPanel;
    Img_Score_Ketchup2: TImage;
    Pan_Score_Mayo2: TPanel;
    Img_Score_Mayo2: TImage;
    But_Dec_Score_Mayo: TSpeedButton;
    But_Inc_Score_Mayo: TSpeedButton;
    But_Dec_Score_Ketchup: TSpeedButton;
    But_Inc_Score_Ketchup: TSpeedButton;
    Pan_Reglages_1: TPanel;
    Lab_Score_Mayo: TLabel;
    Pan_Reglages_2: TPanel;
    Lab_Score_Ketchup: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    pnlFluxSonVideo: TPanel;
    wmpMedia: TWindowsMediaPlayer;
    procedure FormCreate(Sender: TObject);
    procedure QuitterClick(Sender: TObject);
    procedure Book_Main_Next_Page(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure But_Dec_Score_MayoClick(Sender: TObject);
    procedure But_Inc_Score_MayoClick(Sender: TObject);
    procedure But_Dec_Score_KetchupClick(Sender: TObject);
    procedure But_Inc_Score_KetchupClick(Sender: TObject);
    procedure AccueilClick(Sender: TObject);
    procedure ScoresClick(Sender: TObject);
    procedure NuggetsClick(Sender: TObject);
    procedure Sel_ou_PoivreClick(Sender: TObject);
    procedure MenusClick(Sender: TObject);
    procedure AdditionClick(Sender: TObject);
    procedure BurgerDeLaMortClick(Sender: TObject);
    procedure Book_MainPageChanged(Sender: TObject);
    procedure GeneriqueClick(Sender: TObject);
    procedure ReglesClick(Sender: TObject);
    procedure TossClick(Sender: TObject);
    procedure RglagesScoresClick(Sender: TObject);
    procedure CommandesduJour1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure wmpVideoClick(ASender: TObject; nButton, nShiftState: SmallInt;
      fX, fY: Integer);
    procedure FormResize(Sender: TObject);
    procedure Book_MainClick(Sender: TObject);
    procedure Book_MainMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);

  private
    sPatternImagesScore : string;
    iScoreMayo, iScoreKetchup: integer;

    function DonneNomFichierImageScores(kNomEquipe : string; kScore : integer) : string;
    procedure Update_Score_Equipe(const aEquipe : string; const aScore : integer);
    procedure Update_Scores();
    procedure ChargeVideosPages();
    //
  public
    iPageActuelle : integer;
  public
    { Dclarations publiques }
    procedure Gerer_Pages(const kPageActuelle : integer = 1);
    procedure SetMonitor(const aMonitor : TMonitor);
    function DonneNewScore(var aNewScore : integer; const aValeur : integer = 1) : string;
    function ChangeScore(const aEquipe : string; const aValeur : integer = 1) : integer; overload;
    function ChangeScore(const aEquipe : integer; const aValeur : integer = 1) : integer; overload;
    procedure AfficheScore(const aEquipe : string; const aValeur : string = '00'); overload;
    procedure AfficheScore(const aEquipe : string; const aValeur : integer = 0); overload;
    procedure InverseAffichageScores();
    procedure SetCouleurEquipeRepondante(const aColor : integer = clBlack);
  end;

var
    F_Main: TF_Main;

implementation

uses
      EMA_StrUtils, UF_Commandes, Competences
      , UF_ValideReponse
      ;

{$R *.dfm}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Main.FormDestroy(Sender: TObject);
begin
  // Libre la police utilise
  RemoveFontResource(PWideChar(ExtractFilePath(Application.ExeName) + 'font\horseshoeslemonade.ttf'));
  SendMessage(HWND_BROADCAST, WM_FONTCHANGE, 0, 0) ;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Main.FormCreate(Sender: TObject);
begin
  // Charge la police personnalise
  AddFontResource(PWideChar(ExtractFilePath(Application.ExeName) + 'font\horseshoeslemonade.ttf'));
  SendMessage(HWND_BROADCAST, WM_FONTCHANGE, 0, 0) ;

  Color := clBlack;
 // FormStyle := fsStayOnTop;
  WindowState := wsMaximized;

  F_Main.DoubleBuffered := true;

  iScoreMayo := 0;
  iScoreKetchup := 0;
  sPatternImagesScore := ExtractFilePath(Application.ExeName)
    + 'img\#Nomequipe#\Equipe #nomequipe# compteur # miams.jpg'
    ;

  iPageActuelle := 0;
  Book_Main.PageIndex := iPageActuelle;

  Randomize();
  //
  AssureExistenceDossier(ExtractFilePath(Application.ExeName) + '\sessions');
//  ChargeVideosPages();
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Main.FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
var
    kKeyProcessed : boolean;
begin
  kKeyProcessed := True;

  case Key of
    VK_ESCAPE : QuitterClick(Sender);
    65        : But_Inc_Score_KetchupClick(Sender);   // A
    81        : But_Dec_Score_KetchupClick(Sender);   // Q
    80        : But_Inc_Score_MayoClick(Sender);      // P
    77        : But_Dec_Score_MayoClick(Sender);      // M
    {//PB221116:inutilises ?
    87        : if (Book_Main.PageIndex < 61) then begin // W
                  iPageRetour := Book_Main.PageIndex;
                  Book_Main.PageIndex := 65;
                end
                else Book_Main.PageIndex := iPageRetour;
    66 :        if (Book_Main.PageIndex < 61) then begin // B
                  iPageRetour := Book_Main.PageIndex;
                  Book_Main.PageIndex := 61;
                end
                else Book_Main.PageIndex := iPageRetour;
    223 :       if (Book_Main.PageIndex < 61) then begin // !
                  iPageRetour := Book_Main.PageIndex;
                  Book_Main.PageIndex := 64;
                end
                else Book_Main.PageIndex := iPageRetour;
    }
    VK_Left   : Book_Main.PageIndex := Book_Main.PageIndex - 1;
    VK_Right  : Book_Main.PageIndex := Book_Main.PageIndex + 1;
    //PB221115:ajout de la prise de parole des quipes (buzzer ou autre -> touche appuye)
    66 :
//  if (dlgValideReponse.Showing) then
    F_Commandes.SetEquipeRepondante(''); // 'B' (black)
    82 : begin
        F_Commandes.EmetSonFichier(NOM_Fichier_SON_BUZZER1);//'Son buzzer 1.mp3');
        F_Commandes.SetEquipeRepondante(NOM_EQUIPE_KETCHUP); // 'R' (red)
      end;
    89 : begin
        F_Commandes.EmetSonFichier(NOM_Fichier_SON_BUZZER2);//'Son buzzer 2.mP3');
        F_Commandes.SetEquipeRepondante(NOM_EQUIPE_MAYO); // 'Y' (yellow)
      end;
    else
    begin
      kKeyProcessed := False;
    end;
  end;
  if (kKeyProcessed) then Key := 0;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Main.FormResize(Sender: TObject);
begin
  Pan_Score_Ketchup2.Width  := Pan_Score_Ketchup2.Parent.Width div 2;
  Update_Scores();
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Main.SetMonitor(const aMonitor : TMonitor);
begin
  MakeFullyVisible(aMonitor);
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Main.Book_Main_Next_Page(Sender: TObject);
begin
  //if (iPageActuelle + 1) >= Book_Main.Pages.Count then iPageActuelle := 0 else iPageActuelle := iPageActuelle + 1;
  iPageActuelle := (iPageActuelle + 1) mod Book_Main.Pages.Count;
  Gerer_Pages(iPageActuelle);
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Main.ChargeVideosPages();
var
    kNomFichierVideo : string;
    iPageActuelle : integer;
begin
  for iPageActuelle := 8 downto 1 do
  begin
    case iPageActuelle of
      1 : begin kNomFichierVideo := 'Intro Burger Criz.mp4'; end;
      3 : begin kNomFichierVideo := 'Le Toss.mp4'; end;
      4 : begin kNomFichierVideo := 'Nuggets.mp4'; end;
      5 : begin kNomFichierVideo := 'SelOuPoivre.mp4'; end;
      6 : begin kNomFichierVideo := 'Menus.mp4'; end;
      7 : begin kNomFichierVideo := 'Addition.mp4'; end;
      8 : begin kNomFichierVideo := 'BurgerDeLaMort.mp4'; end;
      else begin kNomFichierVideo := ''; end;
    end;
    wmpMedia.Parent.Visible := (kNomFichierVideo <> '');
    if (wmpMedia.Parent.Visible) then
    begin
      kNomFichierVideo := ExtractFilePath(Application.ExeName) + 'vid\' + kNomFichierVideo;
      wmpMedia.settings.autoStart := true;
      wmpMedia.URL := kNomFichierVideo;//ExtractFilePath(Application.ExeName) + 'vid\Intro Burger Criz.mp4';
      wmpMedia.Align := alClient;
      wmpMedia.controls.play;
    end;
  end;
  wmpMedia.controls.stop;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Main.Gerer_Pages(const kPageActuelle : integer);
var
    kSectionIni : string;
    kPhaseApprentissage : TPhaseApprentissage;
    kNomFichierVideo : string;
begin
  wmpMedia.controls.stop;
  wmpMedia.settings.autoStart := false;
  kNomFichierVideo := '';
  kSectionIni := '';
  case kPageActuelle of
    0 : begin kSectionIni := 'Generique';end;
    1 : begin kSectionIni := 'Intro';end;
    3 : begin kSectionIni := 'Toss'; end;
    4 : begin kSectionIni := 'Nuggets'; end;
    5 : begin kSectionIni := 'Sel Ou Poivre'; end;
    6 : begin kSectionIni := 'Menus'; end;
    7 : begin kSectionIni := 'Addition'; end;
    8 : begin kSectionIni := 'Burger De La Mort'; end;
  end;
  if (kSectionIni <> '') then
  begin
    kPhaseApprentissage := F_Commandes.oBurgerCriz.DonnePhase(kSectionIni);
    if (Assigned(kPhaseApprentissage)) then
    begin
      kNomFichierVideo:= kPhaseApprentissage.NomFichierVideo;
    end;
  end;
  wmpMedia.Parent.Visible := (kNomFichierVideo <> '');
  Book_Main.Visible := (not wmpMedia.Parent.Visible);
  if (wmpMedia.Parent.Visible) then
  begin
    F_Commandes.wmpSon.controls.stop;
    wmpMedia.Parent.Align := alClient;
    kNomFichierVideo := ExtractFilePath(Application.ExeName) + 'vid\' + kNomFichierVideo;
    if (FileExists(kNomFichierVideo)) then
    begin
      wmpMedia.settings.autoStart := true;//false;
      wmpMedia.settings.setMode('loop', false);
      wmpMedia.URL := kNomFichierVideo;//ExtractFilePath(Application.ExeName) + 'vid\Intro Burger Criz.mp4';
      wmpMedia.Align := alClient;
      try
        wmpMedia.controls.play;
      except
        wmpMedia.settings.autoStart := false;
      end;
    end;
  end;
  Book_Main.PageIndex := kPageActuelle;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Main.But_Dec_Score_MayoClick(Sender: TObject);
begin
  ChangeScore(NOM_EQUIPE_MAYO, -1);
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Main.But_Inc_Score_MayoClick(Sender: TObject);
begin
  ChangeScore(NOM_EQUIPE_MAYO, 1);
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

function TF_Main.DonneNewScore(var aNewScore : integer; const aValeur : integer = 1) : string;
begin
  aNewScore := Max(0, Min(25, (aNewScore + aValeur)));
  Result := RetourneStringLongueurFixe(aNewScore, 2, '0', False);
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

function TF_Main.ChangeScore(const aEquipe : integer; const aValeur : integer) : integer;
begin
  if (aEquipe = NUM_EQUIPE_MAYO) then
  begin
    Result := ChangeScore(NOM_EQUIPE_MAYO, aValeur);
  end else
  begin
    Result := ChangeScore(NOM_EQUIPE_KETCHUP, aValeur);
  end;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

function TF_Main.ChangeScore(const aEquipe : string; const aValeur : integer) : integer;
var
    kScoreCalcule : integer;
begin
  if (aEquipe = NOM_EQUIPE_MAYO) then
  begin
    DonneNewScore(iScoreMayo, aValeur);
    kScoreCalcule := iScoreMayo;
  end else
  begin
    DonneNewScore(iScoreKetchup, aValeur);
    kScoreCalcule := iScoreKetchup;
  end;
  AfficheScore(aEquipe, kScoreCalcule);
  Result := kScoreCalcule;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Main.AfficheScore(const aEquipe : string; const aValeur : string = '00');
begin
  AfficheScore(aEquipe, StrToInt(aValeur));
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Main.AfficheScore(const aEquipe : string; const aValeur : integer = 0);
var
    kLibValeur : string;
begin
  if (aEquipe <> '') then
  begin
    kLibValeur := RetourneStringLongueurFixe(aValeur, 2, '0', False);
    if (aEquipe = NOM_EQUIPE_MAYO) then
    begin
      Lab_Score_Mayo.Caption := kLibValeur;
    end else
    begin
      Lab_Score_Ketchup.Caption := kLibValeur;
    end;
    Update_Scores();
  end;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Main.But_Inc_Score_KetchupClick(Sender: TObject);
begin
  ChangeScore(NOM_EQUIPE_KETCHUP, 1);
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Main.But_Dec_Score_KetchupClick(Sender: TObject);
begin
  ChangeScore(NOM_EQUIPE_KETCHUP, -1);
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

function TF_Main.DonneNomFichierImageScores(kNomEquipe : string; kScore : integer) : string;
var
    sNomFichier : string;
begin
  sNomFichier := StringReplace(sPatternImagesScore, '#Nomequipe#', kNomEquipe, []);
  sNomFichier := StringReplace(sNomFichier, '#nomequipe#', LowerCase(kNomEquipe), []);
  sNomFichier := StringReplace(sNomFichier, '#', IntToStr(kScore), []);
  Result := sNomFichier;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Main.Update_Score_Equipe(const aEquipe : string; const aScore : integer);
var
    sNomFichier : string;
    kImageScore : TPicture;
    kImageScore2 : TPicture;
begin
  sNomFichier := '';
  kImageScore := nil;
  kImageScore2 := nil;
  if (aEquipe = 'Ketchup') then
  begin
    sNomFichier := aEquipe;
    kImageScore := Img_Score_Ketchup.Picture;
    kImageScore2 := Img_Score_Ketchup2.Picture;
  end else if (aEquipe = 'Mayo') then
  begin
    sNomFichier := aEquipe;
    kImageScore := Img_Score_Mayo.Picture;
    kImageScore2 := Img_Score_Mayo2.Picture;
  end;
  if (sNomFichier <> '') then
  begin
    sNomFichier := DonneNomFichierImageScores(sNomFichier, aScore);
    if (sNomFichier <> '')
      and (Assigned(kImageScore))
      and (Assigned(kImageScore2))
    then
    begin
      try
        kImageScore.LoadFromFile(sNomFichier);
        kImageScore2.LoadFromFile(sNomFichier);
      finally

      end;
    end;
  end;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Main.Update_Scores();
begin
  Update_Score_Equipe('Ketchup', iScoreKetchup);
  Update_Score_Equipe('Mayo', iScoreMayo);
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Main.InverseAffichageScores();
begin
  Pan_Score_Mayo2.Align := alNone;
  if (Pan_Score_Ketchup2.Align = alRight) then
  //ketchup est a droite
  begin
    Pan_Score_Ketchup2.Align := alLeft;
  end else
  begin
    Pan_Score_Ketchup2.Align := alRight;
  end;
  Pan_Score_Ketchup2.Width  := Pan_Score_Ketchup2.Parent.Width div 2;
  Pan_Score_Mayo2.Align := alClient;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Main.CommandesduJour1Click(Sender: TObject);
begin
  F_Commandes.Visible := true;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Main.wmpVideoClick(ASender: TObject; nButton,
  nShiftState: SmallInt; fX, fY: Integer);
begin
  if (nButton = 1) then
  begin
    Book_Main_Next_Page(ASender);
  end;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Main.Book_MainClick(Sender: TObject);
begin
  //Book_Main_Next_Page(Sender);
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Main.Book_MainMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if (Button = mbLeft) then
  begin
    Book_Main_Next_Page(Sender);
  end;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Main.Book_MainPageChanged(Sender: TObject);
begin
  //Update_Scores();
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Main.QuitterClick(Sender: TObject);
var
    sMessage: string;
    oMessages: TStringList;
begin
  oMessages := TStringList.Create;
  oMessages.Add('- Appuyer sur "OK", parce qu''on sait ce qu''on fait et qu''on veut quitter,'
      + Chr(13) + Chr(13)
      + '- Ou appuyer sur "Annuler", mais ce n''est pas la bonne rponse ?'
    );
  oMessages.Add('- Mesurer obligatoirement 1,94m ?'
      + Chr(13) + Chr(13)
      + '- Appuyer sur "OK" ?'
    );
  oMessages.Add('- Appuyer sur "OK", c''est ce qu''il faut faire ?'
      + Chr(13) + Chr(13)
      + '- Appuyer sur "Annuler", mais c''est pas ce qu''il faut faire ?'
    );
  oMessages.Add('- Valider cette fentre avec "Ok" et attendre ?'
      + Chr(13) + Chr(13)
      + '- Jeter l''ordinateur par la fentre et attendre ?'
    );
  oMessages.Add('- Crier "Ok", comme dans les visiteurs ?'
      + Chr(13) + Chr(13)
      + '- Cliquer sur "Ok", tout simplement ?'
    );

  // <-- Rajouter ici autant de messages possibles que l'on souhaite.

  Randomize;

  sMessage := oMessages[Random(oMessages.Count)];
  oMessages.Clear();
  oMessages.Free;

  if (Application.messagebox(
    PWideChar('Pour quitter, faut-il : ' + Chr(13) + Chr(13) + sMessage)
    , 'DERNIERE QUESTION'
    , mb_OkCancel)
    = IDOK)
  then
  begin
    Application.Terminate;
  end;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Main.AccueilClick(Sender: TObject);
begin
  iPageActuelle := 0;
  Gerer_Pages(iPageActuelle);
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Main.GeneriqueClick(Sender: TObject);
begin
  iPageActuelle := 1;
  Gerer_Pages(iPageActuelle);
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Main.ReglesClick(Sender: TObject);
begin
  iPageActuelle := 2;
  Gerer_Pages(iPageActuelle);
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Main.TossClick(Sender: TObject);
begin
  iPageActuelle := 3;
  Gerer_Pages(iPageActuelle);
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Main.NuggetsClick(Sender: TObject);
begin
  iPageActuelle := 4;
  Gerer_Pages(iPageActuelle);
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Main.Sel_ou_PoivreClick(Sender: TObject);
begin
  iPageActuelle := 5;
  Gerer_Pages(iPageActuelle);
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Main.MenusClick(Sender: TObject);
begin
  iPageActuelle := 6;
  Gerer_Pages(iPageActuelle);
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Main.AdditionClick(Sender: TObject);
begin
  iPageActuelle := 7;
  Gerer_Pages(iPageActuelle);
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Main.BurgerDeLaMortClick(Sender: TObject);
begin
  iPageActuelle := 8;
  Gerer_Pages(iPageActuelle);
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Main.ScoresClick(Sender: TObject);
begin
  iPageActuelle := 11;
  Gerer_Pages(iPageActuelle);
  self.SetFocus;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Main.RglagesScoresClick(Sender: TObject);
begin
  iPageActuelle := 12;
  Gerer_Pages(iPageActuelle);
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Main.SetCouleurEquipeRepondante(const aColor : integer);
begin
  Label4.Color := aColor;
end;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

end.