unit UF_Commandes;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms
  , Dialogs, StdCtrls, ExtCtrls, TeEngine, TeeProcs, Chart, Series, WMPLib_TLB
  , ShellAPI, StrUtils, DB, TeeData, IniFiles, pngimage, jpeg, OleCtrls
  //
  , Competences
  ;

const VOL = 10;

type
  TF_Commandes = class(TForm)
    pnlCtrlAnimation: TPanel;
    SaveDialog_Memo: TSaveDialog;
    cbDosAffichage: TCheckBox;
    lblEpreuve: TLabel;
    pnlNotesAnimation: TPanel;
    lblNoteAnimation: TLabel;
    pnlCartes: TPanel;
    lblNumCarte: TLabel;
    btnAnecdoteHaut: TButton;
    btnValideCarte: TButton;
    rdbtnMenuBleu: TRadioButton;
    rdbtnMenuRouge: TRadioButton;
    edNumCarte: TEdit;
    btnAnecdoteMilieu: TButton;
    btnAnecdoteBas: TButton;
    pnlAnimation: TPanel;
    pnlCtrlSon: TPanel;
    btnVolMoins: TButton;
    btnVolPlus: TButton;
    lblVolPercent: TLabel;
    btnMusicOn: TButton;
    btnMusicOff: TButton;
    btnDeplFenetreScore: TButton;
    btnVoirScore: TButton;
    But_Details_Menus: TButton;
    lstbxCartes: TListBox;
    pnlEpreuve: TPanel;
    pnlOutilsEpreuve: TPanel;
    lblMiam: TLabel;
    cobxPointsQuestion: TComboBox;
    ckbxPtsDonnes: TCheckBox;
    pnlValorisationEpreuve: TPanel;
    btnJingle: TButton;
    pnlEntete: TPanel;
    lblMusique: TLabel;
    But_Switch_Visibility_Book: TButton;
    pnlCtrlIhm: TPanel;
    btnQuitter: TButton;
    lblJeuCharge: TLabel;
    pnlChoixEpreuve: TPanel;
    btnNuggets: TButton;
    btnSelPoivre: TButton;
    btnMenus: TButton;
    btnAddition: TButton;
    btnBurgerMort: TButton;
    btnGenerique: TButton;
    btnPresentation: TButton;
    btnChargement: TButton;
    btnToss: TButton;
    btnMasqueBilan: TButton;
    pnlSuiviCartes: TPanel;
    memoCartes: TMemo;
    pnlBoutonsBilan: TPanel;
    btnSauveMemo: TButton;
    btnDetailsSuiviFiches: TButton;
    btnUpdateSuivi: TButton;
    chartBilan: TChart;
    Series1: TPieSeries;
    cobxCartes: TComboBox;
    lblTexteArbitrage: TLabel;
    pnlGestScore: TPanel;
    pnlScoreKetchup: TPanel;
    lblKetchup: TLabel;
    lblScoreKetchup: TLabel;
    btnScoreKetchupMoins: TButton;
    btnScoreKetchupPlus: TButton;
    pnlScoreMayo: TPanel;
    lblMayo: TLabel;
    lblScoreMayo: TLabel;
    btnScoreMayoPlus: TButton;
    btnScoreMayoMoins: TButton;
    btnInversion: TButton;
    pnlReponse: TPanel;
    rdgpEquipe: TRadioGroup;
    rdgpOkKo: TRadioGroup;
    pnlSuggestions: TPanel;
    shpSuggestion1: TShape;
    shpSuggestion2: TShape;
    shpSuggestion3: TShape;
    shpSuggestion4: TShape;
    shpSuggestion5: TShape;
    shpSuggestion6: TShape;
    shpSuggestion7: TShape;
    shpSuggestion8: TShape;
    lblSuggestions: TLabel;
    btnMasqueArbitrage: TButton;
    pnlScores: TPanel;
    pnlMenus: TPanel;
    pnlApplicatif: TPanel;
    btnApropos: TButton;
    pnlChart: TPanel;
    WindowsMediaPlayer1: TWindowsMediaPlayer;
    edNbMiamsManuel: TEdit;
    wmpSon: TWindowsMediaPlayer;
    pnlValeurEffet: TPanel;
    procedure ChoixEpreuve(Sender: TObject);
    procedure btnInversionClick(Sender: TObject);
    procedure btnQuitterClick(Sender: TObject);
    procedure btnJingleClick(Sender: TObject);
    procedure btnScoreKetchupPlusClick(Sender: TObject);
    procedure btnScoreKetchupMoinsClick(Sender: TObject);
    procedure btnScoreMayoPlusClick(Sender: TObject);
    procedure btnScoreMayoMoinsClick(Sender: TObject);
    procedure btnVoirScoreClick(Sender: TObject);
    procedure btnGeneriqueClick(Sender: TObject);
    procedure btnPresentationClick(Sender: TObject);
    procedure btnVolMoinsClick(Sender: TObject);
    procedure btnVolPlusClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnChargementClick(Sender: TObject);
    procedure btnValideCarteClick(Sender: TObject);
    procedure AnecdoteClick(Sender: TObject);
    procedure edNumCarteKeyPress(Sender: TObject; var Key: Char);
    procedure Actualiser_Graphique(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure SuggererDesThemes(Sender: TObject);
    procedure btnUpdateSuiviClick(Sender: TObject);
    procedure btnDetailsSuiviFichesClick(Sender: TObject);
    procedure Button19Click(Sender: TObject);
    procedure btnMusicOffClick(Sender: TObject);
    procedure But_Details_MenusClick(Sender: TObject);
    procedure But_Switch_Visibility_BookClick(Sender: TObject);
    procedure btnDeplFenetreScoreClick(Sender: TObject);
    procedure cbDosAffichageClick(Sender: TObject);
    procedure btnSauveMemoClick(Sender: TObject);
    procedure rdbtnMenuClick(Sender: TObject);
    procedure lstbxCartesDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure lstbxCartesClick(Sender: TObject);
    procedure rdgpOkKoClick(Sender: TObject);
    procedure btnMasqueBilanClick(Sender: TObject);
    procedure cobxCartesChange(Sender: TObject);
    procedure cobxCartesDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure rdgpEquipeClick(Sender: TObject);
    procedure btnMasqueArbitrageClick(Sender: TObject);
    procedure cobxPointsQuestionSelect(Sender: TObject);
    procedure btnAproposClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure edNbMiamsManuelChange(Sender: TObject);
    procedure lblKetchupClick(Sender: TObject);
    procedure lblMayoClick(Sender: TObject);

  private
    iSonMemo : integer;
    olstShapesCompetences : TStringList;
    oCartes, oMenus: TStringList;

    iNbMenusBleus: integer; // Nbre de menus bleus ajouts dans la partie

    procedure SetMonitor(const aForm : TForm; const aMonitor : TMonitor);
    procedure Affichage_Boutons_Anecdotes(const sCarte: string; const aBouton : TButton);
    //
    procedure SetVolume(const aVolume : integer = VOL);
    procedure ChangeVolume(const aVolume : integer = VOL);
    procedure SauveMemo(const aSauveVrai : boolean = false);
    procedure InverseAffichageScores();
    procedure ActualiseListeCartes(const aEpreuve : string);
    procedure AfficheNotesAnimation(const aEpreuve : string);
    function ChangeScore(const aEquipe : string; const aValeur : integer) : integer;
    procedure AfficheScore(const aEquipe : string = ''; const aValeur : integer = 0);
    procedure AjusteLargeur();
    procedure AfficheEquipeRepondante(const aIndexEquipe : integer);
    procedure EffaceEquipeRepondante();
    procedure ValideReponseEquipe();
  private
    function DonneNomCarte(const aEpreuve : string; const aNumCarte : string) : string; reintroduce; overload;
    procedure SelectionneCarte(const aNumCarte : string); reintroduce; overload;
    function ChercheAnecdote(const sCarte: string) : string;
  public
    { Dclarations publiques }
    procedure ChargeCompetences(olstCompetences : TListeCompetences);
    procedure MasqueAfficheIhmEpreuve(const aMasque : boolean = true);
    procedure SetEquipeRepondante(const aNomEquipe : string = '');
    procedure EmetSonFichier(const aNomFichierSon : string; const aSousDossier : string = 'son\');
  public
    oBurgerCriz : TBurgerCriz;
  end;

var
  F_Commandes: TF_Commandes;

var
  F_NomFichierIntro : string;

implementation

uses Math, EMA_StrUtils, UF_Main, UF_Apropos, UF_AffichagesBurgerCriz, UF_ValideReponse;

{$R *.dfm}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if (Assigned(dlgValideReponse)) then
  begin
    dlgValideReponse.Free();
  end;
  Application.Terminate;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.SetMonitor(const aForm : TForm; const aMonitor : TMonitor);
begin
  if (Assigned(aForm)) then
  begin
    aForm.MakeFullyVisible(aMonitor);
  end;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.FormCreate(Sender: TObject);
var
    sFile: string;
    klstShapes : TStringList;
    kShape : TShape;
    kNumCompetence : integer;
    kCompetence : TCompetence;
    kIniFile : TIniFile;
    kSections : TStringList;
    kNumPhase : integer;
    kPhase : TPhaseApprentissage;
    kSection : TStrings;
begin
  inherited;
  dlgValideReponse := TdlgValideReponse.Create(self);
  F_Main.Hide();
  if (Screen.MonitorCount > 1) then
  begin
    if (F_Main.Monitor = self.Monitor) then
    begin
      if (self.Monitor = Screen.Monitors[0]) then
      begin
        SetMonitor(F_Main, Screen.Monitors[1]);
      end else
      begin
        SetMonitor(F_Main, Screen.Monitors[0]);
      end;
    end;
  end;
  F_Main.Pan_Score_Ketchup2.Align  := alLeft;
  F_Main.Pan_Score_Ketchup2.Width  := F_Main.Pan_Score_Ketchup2.Parent.Width div 2;
  F_Main.Pan_Score_Mayo2.Align     := alClient;
  F_Main.Show();

  Top := 0;Left := 0;
  cobxPointsQuestion.Text := '';
  edNbMiamsManuel.Text := '';
  MasqueAfficheIhmEpreuve(true);

  //Gestion du son global
  // Affichage du volume initial
  iSonMemo := F_Main.wmpMedia.settings.volume;
  SetVolume(F_Main.wmpMedia.settings.volume);
  F_Main.wmpMedia.controls.stop;
  btnMusicOff.Enabled := false;
  btnVolMoins.Enabled := btnMusicOff.Enabled;
  btnVolPlus.Enabled := btnMusicOff.Enabled;
  btnMusicOn.Enabled := not(btnMusicOff.Enabled);

  oBurgerCriz := TBurgerCriz.Create();
  rdgpEquipe.Items[0] := oBurgerCriz.EquipeKetchup.Nom;
  rdgpEquipe.Items[1] := oBurgerCriz.EquipeMayo.Nom;

  kIniFile := TIniFile.Create(ReplaceStr(Application.ExeName, '.exe', '.ini'));
  kSections := TStringList.Create();
  kIniFile.ReadSections(kSections);
  kSection := TStringList.Create();
  for kNumPhase := 0 to (kSections.Count - 1) do
  begin
    kSection.Clear();
    kIniFile.ReadSectionValues(kSections[kNumPhase], kSection);
    kPhase := TPhaseApprentissage.Create(kSection, kSections[kNumPhase]);
    oBurgerCriz.Ajoute(kPhase);
  end;
  //chargement des comptences de la session
  ChargeCompetences(oBurgerCriz.lstCompetences);
  //ajustement des pastilles de suggestion de comptence
  olstShapesCompetences := TStringList.Create();
  klstShapes := olstShapesCompetences;
  klstShapes.OwnsObjects := False;
  for kNumCompetence := 0 to (oBurgerCriz.lstCompetences.Count - 1) do
  begin
    kCompetence := oBurgerCriz.lstCompetences.DonneCompetence(kNumCompetence);
    kShape := TShape(FindComponent('shpSuggestion' + IntToStr(kNumCompetence + 1)));
    with kShape do begin Brush.Color := kCompetence.Couleur; Hint := kCompetence.Nom; end;
    klstShapes.AddObject('shpSuggestion' + IntToStr(kNumCompetence),  kShape);
  end;
  // Chargement des cartes et de leurs thmes associs
  sFile := ExtractFilePath(Application.ExeName) + 'Typologie pdagogique.txt';
  oCartes := TStringList.Create;
  oCartes.NameValueSeparator := ';';
  oCartes.LoadFromFile(sFile, TEncoding.UTF8);
  //affichage tmoin des cartes charges
  lblJeuCharge.Caption := (inttostr(oCartes.Count)) + ' carte(s) charge(s)';
  // Chargement des menus et de leurs noms
  sFile := ExtractFilePath(Application.ExeName) + 'Titre des menus.txt';
  oMenus := TStringList.Create;
  oMenus.NameValueSeparator := ';';
  oMenus.LoadFromFile(sFile, TEncoding.UTF8);
  iNbMenusBleus := 0;

  memoCartes.Clear;
  Actualiser_Graphique(Sender);

  AfficheScore();
  F_Main.Gerer_Pages(0);
  btnMusicOn.Click();
  btnApropos.OnClick(self);
  AjusteLargeur();
  if (Assigned(F_Affichages)) then
  begin
    F_Affichages.Show();
    SetMonitor(F_Affichages, F_Main.Monitor);
  end;
  kPhase := oBurgerCriz.DonnePhase('Buzzer1');
  if (Assigned(kPhase)) then
  begin
    NOM_Fichier_SON_BUZZER1 := kPhase.NomFichierVideo;
  end;
  kPhase := oBurgerCriz.DonnePhase('Buzzer2');
  if (Assigned(kPhase)) then
  begin
    NOM_Fichier_SON_BUZZER2 := kPhase.NomFichierVideo;
  end;
  kPhase := oBurgerCriz.DonnePhase('Generique');
  if (Assigned(kPhase)) then
  begin
    EmetSonFichier(kPhase.NomFichierVideo);
  end;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.MasqueAfficheIhmEpreuve(const aMasque : boolean);
begin
  pnlChart.Visible := (not aMasque);
  pnlSuiviCartes.Visible := pnlChart.Visible;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.FormDestroy(Sender: TObject);
begin
  oCartes.Free;
  oMenus.Free;
  olstShapesCompetences.Clear();
  olstShapesCompetences.Free();
  oBurgerCriz.Free();
  inherited;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.FormKeyDown(Sender: TObject; var Key: Word;Shift: TShiftState);
begin
  if (Assigned(F_Main)) then
  begin
    F_Main.FormKeyDown(Sender, Key, Shift);
  end;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.ChargeCompetences(olstCompetences : TListeCompetences);
var kNumCompetence : integer;
begin
  for kNumCompetence := 0 to (chartBilan.Series[0].count - 1) do
  begin
    olstCompetences.Ajoute(chartBilan.Series[0].XLabel[kNumCompetence], chartBilan.Series[0].LegendItemColor(kNumCompetence));
  end;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.SetVolume(const aVolume : integer = VOL);
begin
  wmpSon.settings.volume := Min(Max(0, aVolume), 100);
  F_Main.wmpMedia.settings.volume := wmpSon.settings.volume;
  lblVolPercent.Caption := IntToStr(F_Main.wmpMedia.settings.volume) + '%';

  btnMusicOff.Enabled := (F_Main.wmpMedia.settings.volume > 0);
  btnVolMoins.Enabled := btnMusicOff.Enabled;
  btnVolPlus.Enabled := btnMusicOff.Enabled;
  btnMusicOn.Enabled := not(btnMusicOff.Enabled);

end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.ChangeVolume(const aVolume : integer);
begin
  iSonMemo := F_Main.wmpMedia.settings.volume;
  SetVolume(iSonMemo + aVolume);
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.btnVolMoinsClick(Sender: TObject);
begin
  ChangeVolume(-1 * VOL);
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.btnVolPlusClick(Sender: TObject);
begin
  ChangeVolume(VOL);
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.AjusteLargeur();
var
    kLargeur : integer;
begin
  kLargeur := pnlCtrlIhm.Width;
  if (pnlCtrlAnimation.Visible) then
    kLargeur := kLargeur + pnlCtrlAnimation.Width;
  if (pnlGestScore.Visible) then
    kLargeur := kLargeur + pnlGestScore.Width;
  if (chartBilan.Visible) then
    kLargeur := kLargeur + chartBilan.Width;
  pnlApplicatif.Width := kLargeur;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.btnMasqueArbitrageClick(Sender: TObject);
begin
  pnlGestScore.Visible := not pnlGestScore.Visible;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.But_Switch_Visibility_BookClick(Sender: TObject);
begin
  pnlCtrlAnimation.Visible := not pnlCtrlAnimation.Visible;
  AjusteLargeur();
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.btnMasqueBilanClick(Sender: TObject);
begin
  pnlChart.Visible := not pnlChart.Visible;
  //chartBilan.Visible := not chartBilan.Visible;
  pnlSuiviCartes.Visible := pnlChart.Visible;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.btnMusicOffClick(Sender: TObject);
begin
  if (F_Main.wmpMedia.settings.volume > 0) then
  begin
    iSonMemo := F_Main.wmpMedia.settings.volume;
    SetVolume(0);
  end;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.Button19Click(Sender: TObject);
begin
  SetVolume(iSonMemo);
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.btnVoirScoreClick(Sender: TObject);
begin
  F_Main.ScoresClick(Sender);
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.btnGeneriqueClick(Sender: TObject);
begin
  F_Main.GeneriqueClick(Sender);
  MasqueAfficheIhmEpreuve(true);
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.btnPresentationClick(Sender: TObject);
begin
  F_Main.ReglesClick(Sender);
  MasqueAfficheIhmEpreuve(true);
  btnMusicOn.Click();
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.btnAproposClick(Sender: TObject);
begin
  F_Main.Show();
  if (not Assigned(frmApropos)) then
  begin
    frmApropos := TfrmApropos.Create(F_Main);
  end;
  frmApropos.Top := F_Main.Top + (F_Main.Height - frmApropos.Height) div 2;
  frmApropos.Show();
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.btnChargementClick(Sender: TObject);
begin
  F_Main.AccueilClick(Sender);
  MasqueAfficheIhmEpreuve(true);
  btnMusicOn.Click();
  self.SauveMemo(False);
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.btnDetailsSuiviFichesClick(Sender: TObject);
begin
  memoCartes.Visible := not memoCartes.Visible;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.btnUpdateSuiviClick(Sender: TObject);
begin
  self.Actualiser_Graphique(Sender);
  self.SuggererDesThemes(Sender);
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.SuggererDesThemes(Sender: TObject);
var
    iMoy: integer;
    kNumCompetence : integer;
begin
  iMoy := 0;
  for kNumCompetence := 0 to (oBurgerCriz.lstCompetences.count - 1) do
  begin
    Inc(iMoy, TCompetence(oBurgerCriz.lstCompetences.Objects[kNumCompetence]).Valorisation);
  end;
  iMoy := Round(iMoy div oBurgerCriz.lstCompetences.count);
  for kNumCompetence := 0 to (oBurgerCriz.lstCompetences.count - 1) do
  begin
    if (iMoy >= TCompetence(oBurgerCriz.lstCompetences.Objects[kNumCompetence]).Valorisation) then
    begin
      TShape(olstShapesCompetences.Objects[kNumCompetence]).Brush.Color := TCompetence(oBurgerCriz.lstCompetences.Objects[kNumCompetence]).Couleur;
    end else
    begin
      TShape(olstShapesCompetences.Objects[kNumCompetence]).Brush.Color := TPanel(TShape(olstShapesCompetences.Objects[kNumCompetence]).Parent).Color;
    end;
  end;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.Actualiser_Graphique(Sender: TObject);
var
    i: integer;
    sCarte, sType: string;
    kNumCarte : integer;
    kNumCompetence : integer;
begin
  // Rinitialisation des valeurs du graphique
  for kNumCompetence := 0 to (oBurgerCriz.lstCompetences.Count - 1) do
  begin
    oBurgerCriz.lstCompetences.DonneCompetence(kNumCompetence).Valorisation := 0;
  end;
  // On compte dans le memo combien de type on a
  for i := 0 to memoCartes.Lines.Count - 1 do begin
    sCarte := memoCartes.Lines[i];
    sType := '';
    kNumCarte := oCartes.IndexOfName(sCarte);
    if ((kNumCarte > -1) and (kNumCarte < oCartes.count)) then
    begin
      sType := oCartes.ValueFromIndex[kNumCarte];
      Inc(oBurgerCriz.lstCompetences.DonneCompetence(sType).Valorisation);
    end;
  end;
  for kNumCompetence := 0 to (oBurgerCriz.lstCompetences.Count - 1) do
  begin
    chartBilan.Series[0].YValue[kNumCompetence] := oBurgerCriz.lstCompetences.DonneCompetence(kNumCompetence).Valorisation;
  end;
  chartBilan.AxisVisible := true;//(memoCartes.Lines.Count > 0);
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//191016:nouvelle gestion pour inversion des scores
procedure TF_Commandes.InverseAffichageScores();
var
    kNomEquipeMemo : string;
begin
  if pnlScoreKetchup.Align = alRight then  //ketchup est a droite
  begin
    pnlScoreKetchup.Align := alLeft;  //ketchup passe a gauche
    pnlScoreMayo.Align := alRight;  //mayo passe a droite
  end else  //ketchup est a gauche
  begin
    pnlScoreKetchup.Align := alRight;  //ketchup passe a droite
    pnlScoreMayo.Align := alLeft;  //mayo passe a gauche
  end;
  kNomEquipeMemo := rdgpEquipe.Items[0];
  rdgpEquipe.Items[0] := rdgpEquipe.Items[1];
  rdgpEquipe.Items[1] := kNomEquipeMemo;
  if (rdgpEquipe.ItemIndex > -1) then
    rdgpEquipe.ItemIndex := ((rdgpEquipe.ItemIndex + 1) mod 2);
  //191016:ajout inversion des panneaux de scores dans la fenetre principale
  F_Main.InverseAffichageScores();
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.lblKetchupClick(Sender: TObject);
begin
  EmetSonFichier(NOM_Fichier_SON_BUZZER1);
end;

procedure TF_Commandes.lblMayoClick(Sender: TObject);
begin
  EmetSonFichier(NOM_Fichier_SON_BUZZER2);
end;

procedure TF_Commandes.lstbxCartesClick(Sender: TObject);
begin
  SelectionneCarte((Sender as TListBox).Items[(Sender as TListBox).ItemIndex]);
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.lstbxCartesDrawItem(Control: TWinControl; Index: Integer;
  Rect: TRect; State: TOwnerDrawState);
var
    kNomCarte : string;
    sType : string;
    kCompetence : TCompetence;
begin
  kNomCarte := self.DonneNomCarte(lblEpreuve.Caption, (Control as TListBox).Items[Index]);
  sType := oCartes.Values[kNomCarte];
  kCompetence := oBurgerCriz.lstCompetences.DonneCompetence(sType);
  with (Control as TListBox).Canvas do  { Draw on control canvas, not on the form. }
  begin
    Brush.Color := kCompetence.Couleur;
    FillRect(Rect);       { Clear the rectangle. }
    TextOut(Rect.Left, Rect.Top, (Control as TListBox).Items[Index])  { Display the text. }
  end;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.rdbtnMenuClick(Sender: TObject);
begin
  ActualiseListeCartes('Menus');
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.btnJingleClick(Sender: TObject);
begin
  if lblEpreuve.Caption = 'Toss' then
  begin
    F_Main.TossClick(Sender);
  end else if lblEpreuve.Caption = 'Nuggets' then
  begin
    F_Main.NuggetsClick(Sender);
  end else if lblEpreuve.Caption = 'Sel ou Poivre' then
  begin
    F_Main.Sel_ou_PoivreClick(Sender);
  end else if lblEpreuve.Caption = 'Menus' then
  begin
    F_Main.MenusClick(Sender);
  end else if lblEpreuve.Caption = 'Addition' then
  begin
    F_Main.AdditionClick(Sender);
  end else if lblEpreuve.Caption = 'Burger de la Mort' then
  begin
    F_Main.BurgerDeLaMortClick(Sender);
  end;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.btnDeplFenetreScoreClick(Sender: TObject);
begin
  if F_Main.BorderStyle = bsNone then
  begin
    F_Main.BorderStyle := bsSingle;
    btnDeplFenetreScore.Caption := 'Fentre sans barre';
  end else
  begin
    F_Main.BorderStyle := bsNone;
    btnDeplFenetreScore.Caption := 'Bouton dplacement';
  end;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.btnScoreKetchupPlusClick(Sender: TObject);
begin
  ChangeScore(NOM_EQUIPE_KETCHUP, StrToInt(TButton(Sender).Caption));
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.btnScoreKetchupMoinsClick(Sender: TObject);
begin
  ChangeScore(NOM_EQUIPE_KETCHUP, StrToInt(TButton(Sender).Caption));
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.btnScoreMayoPlusClick(Sender: TObject);
begin
  ChangeScore(NOM_EQUIPE_MAYO, StrToInt(TButton(Sender).Caption));
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.btnScoreMayoMoinsClick(Sender: TObject);
begin
  ChangeScore(NOM_EQUIPE_MAYO, StrToInt(TButton(Sender).Caption));
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.rdgpEquipeClick(Sender: TObject);
begin
  AfficheEquipeRepondante(TRadioGroup(Sender).ItemIndex);
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.SetEquipeRepondante(const aNomEquipe : string);
var
    kIndexEquipe : integer;
begin
  kIndexEquipe := rdgpEquipe.Items.IndexOf(aNomEquipe);
  //affichage quipe rpondante
  if (kIndexEquipe <> -1) then
  begin
    //ajuste bouton radio quipe rpondante
    rdgpEquipe.ItemIndex := kIndexEquipe;  //affectation ItemIndex dclenche OnClick, sauf pour (-1)
  end else
  begin
    EffaceEquipeRepondante();
  end;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.EmetSonFichier(const aNomFichierSon : string; const aSousDossier : string);
var
    kNomFichierSon : string;
begin
  kNomFichierSon := ExtractFilePath(Application.ExeName) + aSousDossier + aNomFichierSon;
  if (FileExists(kNomFichierSon)) then
  begin
    try
      wmpSon.settings.autoStart := true;
      wmpSon.URL := kNomFichierSon;
      wmpSon.controls.play;
    except
    end;
  end;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.EffaceEquipeRepondante();
begin
  rdgpEquipe.ItemIndex := -1;
  rdgpEquipe.ParentColor := True;
  rdgpEquipe.Enabled := True;
  rdgpOkKo.Enabled := False;
  rdgpOkKo.Color := rdgpEquipe.Color;
  rdgpOkKo.Caption := 'Rponse quipe';
  F_Main.SetCouleurEquipeRepondante(clBlack);
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.AfficheEquipeRepondante(const aIndexEquipe : integer);
var
    kNomEquipeRepondante : string;
begin
  rdgpEquipe.Enabled := False;
  if (aIndexEquipe <> -1) then
  begin
    kNomEquipeRepondante := rdgpEquipe.Items[aIndexEquipe];
    //affichage quipe rpondante
    if (kNomEquipeRepondante = NOM_EQUIPE_KETCHUP) then
    begin
      rdgpEquipe.Color := lblKetchup.Font.Color;
    end else if (kNomEquipeRepondante = NOM_EQUIPE_MAYO) then
    begin
      rdgpEquipe.Color := lblMayo.Font.Color;
    end else
    begin
      rdgpEquipe.ParentColor := True;
    end;
    rdgpOkKo.Enabled := (kNomEquipeRepondante <> '');
    rdgpOkKo.Color := rdgpEquipe.Color;
    rdgpOkKo.Caption := 'Rponse quipe';
    if (rdgpOkKo.Enabled) then
    begin
      rdgpOkKo.Caption := rdgpOkKo.Caption + ' ' + kNomEquipeRepondante;
      F_Main.SetCouleurEquipeRepondante(rdgpOkKo.Color);
      //affiche la fentre de validation de la rponse
      ValideReponseEquipe();
    end;
  end;
  rdgpEquipe.Enabled := True;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.ValideReponseEquipe();
var
    kRetourDlg : integer;
    kEquipeScoreChange : string;
    kIndexEquipeRepondante : integer;
begin
  kIndexEquipeRepondante := rdgpEquipe.ItemIndex;
  if (kIndexEquipeRepondante > -1) then
  begin
    kEquipeScoreChange := rdgpEquipe.Items[kIndexEquipeRepondante];
    dlgValideReponse.Color := rdgpEquipe.Color;
    dlgValideReponse.lblMessage.Caption := 'La rponse de l''quipe ' + kEquipeScoreChange + ' est-elle valide ?';
    kRetourDlg := dlgValideReponse.ShowModal();
    if (kRetourDlg = mrNo)
      and (ckbxPtsDonnes.Checked)
    then
    begin
      kEquipeScoreChange := rdgpEquipe.Items[(kIndexEquipeRepondante + 1) mod 2];
    end else if ((kRetourDlg <> mrOk) and (kRetourDlg <> mrYes)) then
    begin
      kEquipeScoreChange := '';
    end;
    if (kEquipeScoreChange <> '') then
    begin
      ChangeScore(kEquipeScoreChange, StrToInt(cobxPointsQuestion.Items[cobxPointsQuestion.ItemIndex]));
    end;
    if (kRetourDlg <> mrCancel) then
    begin
      EffaceEquipeRepondante();
    end;
  end;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.rdgpOkKoClick(Sender: TObject);
var
    kEquipeScoreChange : string;
    kIndexReponseOkKo : integer;
begin
  kEquipeScoreChange := '';
  kIndexReponseOkKo := TRadioGroup(Sender).ItemIndex;
  if (kIndexReponseOkKo > -1) then
  begin
    TRadioGroup(Sender).enabled := False;
    if (TRadioGroup(Sender).Items[kIndexReponseOkKo] = 'OK') then
    begin
      kEquipeScoreChange := rdgpEquipe.Items[rdgpEquipe.ItemIndex];
    end else if (ckbxPtsDonnes.Checked)then
    begin
      kEquipeScoreChange := rdgpEquipe.Items[(rdgpEquipe.ItemIndex + 1) mod 2];
    end;
    if (kEquipeScoreChange <> '') then
    begin
      ChangeScore(kEquipeScoreChange, StrToInt(cobxPointsQuestion.Items[cobxPointsQuestion.ItemIndex]));
    end;
    TRadioGroup(Sender).ItemIndex := -1;
    EffaceEquipeRepondante();
    TRadioGroup(Sender).enabled := True;
  end;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

function TF_Commandes.ChangeScore(const aEquipe : string; const aValeur : integer) : integer;
var
    kValeurModifScore : integer;
begin
    kValeurModifScore := F_Main.ChangeScore(aEquipe, aValeur);
    AfficheScore(aEquipe, kValeurModifScore);
    Result := kValeurModifScore;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.AfficheScore(const aEquipe : string = ''; const aValeur : integer = 0);
var
    kNomEquipe : string;
begin
  kNomEquipe := aEquipe;
  if (kNomEquipe = '') then
    kNomEquipe := NOM_EQUIPE_KETCHUP;
  if (kNomEquipe = NOM_EQUIPE_KETCHUP) then
  begin
    lblScoreKetchup.Caption := IntToStr(aValeur);
    F_Main.AfficheScore(kNomEquipe, aValeur);
  end;
  if (aEquipe = '') then
    kNomEquipe := NOM_EQUIPE_MAYO;
  if (kNomEquipe = NOM_EQUIPE_MAYO) then
  begin
    lblScoreMayo.Caption := IntToStr(aValeur);
    F_Main.AfficheScore(kNomEquipe, aValeur);
  end;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.btnInversionClick(Sender: TObject);
begin
  InverseAffichageScores();
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.btnQuitterClick(Sender: TObject);
begin
  F_Main.QuitterClick(Sender);
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.AnecdoteClick(Sender: TObject);
var
    sAnecdote: string;
    iRetour : integer;
begin
  // Rcupration du nom de fichier sans l'extension.
  sAnecdote := ExtractFilePath(Application.ExeName) + 'ppt\' + (Sender as TButton).Hint;
  // On tente de lancer le fichier prfrentiellement en mode visionneuse (ppsx) et sinon en mode cration (pptx).
  if FileExists(sAnecdote + '.ppsx') then
    sAnecdote := sAnecdote + '.ppsx'
  else if FileExists(sAnecdote + '.pptx') then
    sAnecdote := sAnecdote + '.pptx'
  else if FileExists(sAnecdote + '.pps') then
    sAnecdote := sAnecdote + '.pps'
  else if FileExists(sAnecdote + '.ppt') then
    sAnecdote := sAnecdote + '.ppt'
  //PB220509:ajout du traitement de son en anecdote/illustration
  else if FileExists(sAnecdote + '.mp3') then
    sAnecdote := sAnecdote + '.mp3'
  ;
  if FileExists(sAnecdote) then
  begin
    EmetSonFichier(sAnecdote, '');
    iRetour := ShellExecute(Handle, 'Open', PWideChar(sAnecdote), '/S', nil, SW_SHOWDEFAULT);
  end;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.SauveMemo(const aSauveVrai : boolean);
begin
  if SaveDialog_Memo.FileName = '' then
  begin
    SaveDialog_Memo.FileName := ExtractFilePath(Application.ExeName)
      + 'sessions\burgercriz-memo-'
      + RetourneAAAAMMJJ()
      + '.txt'
      ;
    if (not SaveDialog_Memo.Execute) then
    begin
      SaveDialog_Memo.FileName := '';
    end;
  end;
  if ((aSauveVrai)
    and (SaveDialog_Memo.FileName <> '')
    )
  then
  begin
    memoCartes.Lines.SaveToFile(SaveDialog_Memo.FileName);
  end;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.btnSauveMemoClick(Sender: TObject);
begin
  SauveMemo(True);
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

function TF_Commandes.DonneNomCarte(const aEpreuve : string; const aNumCarte : string) : string;
var
    Carte : string;
begin
  Carte := '';
  if (aEpreuve = 'Toss')
    or (aEpreuve = 'Nuggets')
    or (aEpreuve = 'Sel ou Poivre')
    or (aEpreuve = 'Menus')
    or (aEpreuve = 'Addition')
    or (aEpreuve = 'Burger de la Mort')
  then
  begin
    if (aEpreuve = 'Menus') then
    begin
      if rdbtnMenuBleu.Checked then
      begin
        Carte := 'B';
      end else
      begin
        Carte := 'R';
      end;
    end;
    Carte := RemplaceOccurrences(aEpreuve, ' ', '') + Carte + '_';
    try
      Carte := Carte + IntToStr(StrToInt(aNumCarte));
    except
      Carte := Carte + aNumCarte;
    end;
  end;
  Result := Carte;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.SelectionneCarte(const aNumCarte : string);
var
    sCarte: string;
    kBouton : TButton;
    kLabelMenu : TLabel;
begin
  sCarte := DonneNomCarte(lblEpreuve.Caption, aNumCarte);
  if (lblEpreuve.Caption = 'Toss')
    or (lblEpreuve.Caption = 'Nuggets')
    or (lblEpreuve.Caption = 'Sel ou Poivre')
    or (lblEpreuve.Caption = 'Menus')
    or (lblEpreuve.Caption = 'Addition')
    or (lblEpreuve.Caption = 'Burger de la Mort')
  then
  begin
    kBouton := btnAnecdoteBas;
    if lblEpreuve.Caption = 'Menus' then
    begin
      if rdbtnMenuBleu.Checked then
      begin
        iNbMenusBleus := iNbMenusBleus + 1;
        if (iNbMenusBleus > 2) then iNbMenusBleus := 1;  // On alterne entre 1 et 2
        case iNbMenusBleus of
          1 : kBouton := btnAnecdoteHaut;
          2 : kBouton := btnAnecdoteMilieu;
        end;
      end;
    end;
    Affichage_Boutons_Anecdotes(sCarte, kBouton);
    memoCartes.Lines.Add(sCarte);
    Actualiser_Graphique(self);
    SuggererDesThemes(self);
    if lblEpreuve.Caption = 'Menus' then
    begin
      sCarte := ' : ' + oMenus.ValueFromIndex[oMenus.IndexOfName(sCarte)];
      // Affichage du titre
      kLabelMenu := F_Main.Label3;
      if rdbtnMenuBleu.Checked then
      begin
        case iNbMenusBleus of
          1 : kLabelMenu := F_Main.Label1;
          2 : kLabelMenu := F_Main.Label2;
        end;
        sCarte := 'Bleu ' + IntToStr(iNbMenusBleus) + sCarte;
      end else
      begin
        sCarte := 'Rouge' + sCarte;
      end;
      sCarte := 'Menu Cordon ' + sCarte;
      kLabelMenu.Caption := sCarte;
      But_Details_MenusClick(self);
    end;
  end;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.btnValideCarteClick(Sender: TObject);
begin
  if (Sender is TEdit) then
  begin
    SelectionneCarte(edNumCarte.Text);
    TEdit(Sender).Text := '';
  end;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

function TF_Commandes.ChercheAnecdote(const sCarte: string) : string;
var
    kNomFichierCarte : string;
begin
  kNomFichierCarte := ExtractFilePath(Application.ExeName) + 'ppt\' + sCarte + '.';
  //Fichier en mode visionneuse
  Result := 'pps';
  if (not FileExists(kNomFichierCarte + Result)) then
  begin
    //Fichier en mode visionneuse
    Result := Result + 'x';
    if (not FileExists(kNomFichierCarte + Result)) then
    begin
      //Fichier texte
      Result := 'txt';
      if (not FileExists(kNomFichierCarte + Result)) then
      begin
        //Fichier PPT
        Result := 'ppt';
        if (not FileExists(kNomFichierCarte + Result)) then
        begin
          Result := Result + 'x';
          if (not FileExists(kNomFichierCarte + Result)) then
          begin
            //Fichier audio
            Result := 'mp3';
            if (not FileExists(kNomFichierCarte + Result)) then
            begin
              //Fichier video
              Result := 'mp4';
              if (not FileExists(kNomFichierCarte + Result)) then
              begin
                Result := '';
              end;
            end;
          end;
        end;
      end;
    end;
  end;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.Affichage_Boutons_Anecdotes(const sCarte: string; const aBouton : TButton);
var
    kLibelleBoutonAnecdote : string;
begin
  // On affiche un bouton Anecdote si un complment est disponible pour la carte courante.
  if (Assigned(aBouton)) then
  begin
    aBouton.Visible := (ChercheAnecdote(sCarte) <> '');
    if (aBouton.Visible) then
    begin
      aBouton.Hint := sCarte;
      if (lblEpreuve.Caption = 'Menus') then
      begin
        if (rdbtnMenuBleu.Checked) then
        begin
          if (aBouton = btnAnecdoteHaut) then
          begin
            kLibelleBoutonAnecdote := '1';
          end else
          begin
            kLibelleBoutonAnecdote := '2';
          end;
          kLibelleBoutonAnecdote := 'Bl' + kLibelleBoutonAnecdote;
        end else
        begin
          kLibelleBoutonAnecdote := 'Rg';
        end;
        kLibelleBoutonAnecdote := kLibelleBoutonAnecdote + '_';
      end else
      begin
        kLibelleBoutonAnecdote := '';
      end;
      aBouton.Caption := kLibelleBoutonAnecdote + sCarte;
    end;
  end;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.But_Details_MenusClick(Sender: TObject);
begin
  F_Main.Label1.Align := alTop;
  F_Main.Label3.Align := alBottom;

  F_Main.Label2.Align := alNone;
  F_Main.Label2.Width := F_Main.Label2.Parent.Width;
  F_Main.Label2.Top := F_Main.Label1.Height + (F_Main.Height - F_Main.Label1.Height - F_Main.Label2.Height - F_Main.Label3.Height) div 2;
  F_Main.Label2.Left := (F_Main.Width - F_Main.Label2.width) div 2;

  F_Main.iPageActuelle := 13;
  F_Main.Gerer_Pages(F_Main.iPageActuelle);
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.cbDosAffichageClick(Sender: TObject);
begin
  F_Main.InverseAffichageScores();
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.ChoixEpreuve(Sender: TObject);
var
    kPhase : TPhaseApprentissage;
begin
  if (frmApropos.Visible) then
  begin
    frmApropos.Close();
  end;
  lblEpreuve.Caption := TButton(Sender).Caption;
  //on cache les boutons Anecdote
  btnAnecdoteHaut.Visible := false;
  btnAnecdoteMilieu.Visible := false;
  btnAnecdoteBas.Visible := false;
  //on efface le champ numro de carte choisie
  edNumCarte.Text := '';
  F_Main.Label4.Caption := lblEpreuve.Caption;
  //configure ihm en fonction de l'preuve choisie
  pnlMenus.Visible := false;

  kPhase := oBurgerCriz.DonnePhase(lblEpreuve.Caption);
  if (Assigned(kPhase)) then
  begin
    cobxPointsQuestion.ItemIndex := cobxPointsQuestion.Items.IndexOf(
      RetourneStringLongueurFixe(
        kPhase.Valorisation
        , 1
        , '0'
        , True
        )
      );
    edNbMiamsManuel.Text := IntToStr(kPhase.Valorisation);
    ckbxPtsDonnes.Checked := kPhase.EchecPenalise;
  end;
  ActualiseListeCartes(lblEpreuve.Caption);
  AfficheNotesAnimation(lblEpreuve.Caption);
  //pnlSuiviCartes.Visible := pnlChart.Visible and (cobxCartes.Items.Count > 0);
  //pnlChart.Visible := pnlSuiviCartes.Visible;
  SetEquipeRepondante('');
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.cobxCartesChange(Sender: TObject);
var
    kNomCarte : string;
begin
  kNomCarte := (Sender as TComboBox).Items[(Sender as TComboBox).ItemIndex];
  SelectionneCarte(kNomCarte);
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.cobxCartesDrawItem(Control: TWinControl; Index: Integer;
  Rect: TRect; State: TOwnerDrawState);
var
    kNomCarte : string;
    sType : string;
    kCompetence : TCompetence;
begin
  kNomCarte := self.DonneNomCarte(lblEpreuve.Caption, (Control as TComboBox).Items[Index]);
  sType := oCartes.Values[kNomCarte];
  if (sType <> '') then
  begin
    kCompetence := oBurgerCriz.lstCompetences.DonneCompetence(sType);
    with (Control as TComboBox).Canvas do  { Draw on control canvas, not on the form. }
    begin
      if (Assigned(kCompetence)) then
      begin
        Brush.Color := kCompetence.Couleur;
      end;
      FillRect(Rect);       { Clear the rectangle. }
      TextOut(Rect.Left, Rect.Top, (Control as TComboBox).Items[Index])  { Display the text. }
    end;
  end;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.cobxPointsQuestionSelect(Sender: TObject);
var
    kNbMiam : integer;
begin
  kNbMiam := StrToInt(TComboBox(Sender).Items[TComboBox(Sender).ItemIndex]);
  edNbMiamsManuel.Text := IntToStr(kNbMiam);
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.ActualiseListeCartes(const aEpreuve : string);
var
    kNumCarte : integer;
    kNomEpreuveCompresse : string;
    kPosSeparateurNumCarte : integer;
    kNomEpreuveCarte : string;
    kNomFichierCarte : string;
begin
  kNomEpreuveCompresse := RemplaceOccurrences(aEpreuve, ' ', '');
  if (SameStr(aEpreuve, 'Menus')) then
  begin
    if (rdbtnMenuBleu.Checked) then
    begin
      kNomEpreuveCompresse := kNomEpreuveCompresse + 'B';
    end else if (rdbtnMenuRouge.Checked) then
    begin
      kNomEpreuveCompresse := kNomEpreuveCompresse + 'R';
    end;
  end;
  lstbxCartes.Items.Clear();
  cobxCartes.Items.Clear();
  for kNumCarte := 0 to (oCartes.Count - 1) do
  begin
    kPosSeparateurNumCarte := Pos('_', oCartes.Names[kNumCarte]);
    kNomEpreuveCarte := LeftStr(oCartes.Names[kNumCarte], kPosSeparateurNumCarte - 1);
    if (SameStr(UpperCase(RemplaceOccurrences(kNomEpreuveCarte, ' ', '')), UpperCase(kNomEpreuveCompresse))) then
    begin
      kNomFichierCarte :=
        RetourneStringLongueurFixe(
          RightStr(oCartes.Names[kNumCarte], Length(oCartes.Names[kNumCarte]) - kPosSeparateurNumCarte)
          , 2, ' '
          );
      lstbxCartes.Items.Add(
        kNomFichierCarte
        );
      cobxCartes.Items.Add(
        kNomFichierCarte
        );
    end;
  end;
  cobxCartes.DropDownCount := cobxCartes.Items.Count;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.AfficheNotesAnimation(const aEpreuve : string);
begin
  lblNoteAnimation.Caption := ' voir avec le Grand Miam !';
  lblTexteArbitrage.Caption := 'Grand Miam';
  if (aEpreuve = 'Toss') then
  begin
    lblNoteAnimation.Caption := '<oreillette> Ah, on me dit que le Toss du Jour va vous tre servi'
      + #13#10 + '<jingle>' + #13#10
      + 'Je vais demander  un joueur par quipe de me rejoindre.'
      + ' Celui de vous 2 qui remporte le Toss va permettre  son quipe de prendre la main et pourra'
      + ' choisir de jouer sous la couleur de son choix : Ketchup ou Mayo.'
      + ' Est-ce que vous tes prts ?'
      + ' Le Grand Miam est-il prt ?'
      ;

  end else
  if (aEpreuve = 'Nuggets') then
  begin
    lblNoteAnimation.Caption := 'On va commencer par les nuggets'
      + #13#10 + '<jingle>' + #13#10
      + 'Pour les nuggets, c''est 1 question, 4 propositions et 1 seule bonne rponse.'
      + ' Ce n''est pas une question de rapidit et vous pouvez vous concerter.'
      ;

    lblTexteArbitrage.Caption := '3 cartes par quipe. 1 Miam par bonne rponse. Le Miam ne va pas  l''quipe adverse.';
  end else
  if (aEpreuve = 'Sel ou Poivre') then
  begin
    lblNoteAnimation.Caption := 'Maintenant le Sel ou Poivre'
      + #13#10 + '<jingle>' + #13#10
      + 'Ici, il va y avoir 7 questions sur ce thme... <carte>.'
      + ' Ce sont des questions de rapidit.'
      + ' Vous allez me dire si c''est ... ou ... ou les 2.'
      + ' Si vous pensez avoir la bonne rponse, vous cheesebuzzez.'
      + ' Si vous donnez la bonne rponse, c''est 1 Miam, sinon le Miam va a l''quipe adverse.'
      + ' C''est la 1re rponse donne qui compte.'
      ;

    lblTexteArbitrage.Caption := '1 seule carte. 1 Miam par bonne rponse. Le Miam va  l''quipe adverse sinon.';
  end else
  if (aEpreuve = 'Menus') then
  begin
    pnlMenus.Visible := True;
    {rdbtnMenuBleu.Visible := true;
    rdbtnMenuRouge.Visible := true;
    But_Details_Menus.Visible := true;}
    Randomize();
    case Random(6) of
      0: lblNoteAnimation.Caption := 'Les menus que vous propose lquipe du Burger Criz aujourdhui sont les suivants... ';
      1: lblNoteAnimation.Caption := 'Trois menus, les menus du jour, les voici... ';
      2: lblNoteAnimation.Caption := 'Vous avez 3 menus  votre disposition comme tous les jours... ';
      3: lblNoteAnimation.Caption := 'Au programme du jour, trois menus quilibrs. Et il y en a pour tous les gots... ';
      4: lblNoteAnimation.Caption := 'Aujourd''hui, le Chef a travaill sur trois menus thmatiques... ';
      else
        lblNoteAnimation.Caption := 'J''ai 2 menus Cordons Bleus et 1 menu Cordon Rouge  vous proposer... ';
    end;
    lblNoteAnimation.Caption := '<oreillette> Ah ! Les menus sont prts !' + #13#10 + '<jingle>' + #13#10
      + lblNoteAnimation.Caption
      + 'C''est pas un questionnaire de rapidit... Et si vous voulez un avant got, demandez-moi ! '
      + '(parcourir le menu dur  la fin).';

    lblTexteArbitrage.Caption := '2 Bleus - 1 Rouge. 1 Miam par bonne rponse. Le Miam ne va pas  l''quipe adverse.';
  end else
  if (aEpreuve = 'Addition') then
  begin
    lblNoteAnimation.Caption := 'Je vous envoie l''Addition'
      + #13#10 + '<jingle>' + #13#10
      + 'Ce sont des questions de rapidit. Vous cheesebuzzez.'
      + ' Si vous donnez la bonne rponse, vous avez 3 Miams, sinon les 3 Miams vont a l''quipe adverse.'
      + ' C''est la 1re rponse donne qui compte. Attention ! '
      + 'Si vous cheezebuzzez avant la fin de la question, vous devez donner l''intitul exact de la question avant de rpondre.'
      ;

    lblTexteArbitrage.Caption := 'Autant de cartes que nc. 3 Miams par bonne rponse. Les 3 Miams vont  l''quipe adverse sinon.';
  end else
  if (aEpreuve = 'Burger de la Mort') then
  begin
    lblNoteAnimation.Caption := 'Bravo ! Cest lheure maintenant du Burger de la Mort'
      + #13#10 + '<jingle>' + #13#10
      + 'Je vais poser 10 questions.'
      + ' Vous navez pas le droit de me rpondre avant la fin des 10 questions.'
      + ' A la fin des 10 questions, vous devez me donner les 10 rponses dans lordre.'
      + ' Pour les autres, il est interdit daider, de souffler les rponses...'
      + ' Est-ce que cest compris ?'
      ;
  end;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.edNbMiamsManuelChange(Sender: TObject);
begin
  btnScoreKetchupPlus.Caption := '+' + edNbMiamsManuel.Text;
  btnScoreKetchupMoins.Caption := '-' + edNbMiamsManuel.Text;
  btnScoreMayoPlus.Caption := btnScoreKetchupPlus.Caption;
  btnScoreMayoMoins.Caption := btnScoreKetchupMoins.Caption;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

procedure TF_Commandes.edNumCarteKeyPress(Sender: TObject; var Key: Char);
begin
  if (Key=Char(VK_RETURN)) then
  begin
    btnValideCarteClick(btnValideCarte);
    key := #0; // Permet de dvier le code de la touche entre pour viter le beep de windows (signifiant que le passage en multi-ligne est bloqu).
  end;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

end.
