unit EMA_StrUtils;

interface

function RemplaceOccurrences(aStr : string
    ; const aStrCherchee : string = ' '
    ; const aStrRemplacement : string = ''
    ) : string;
function RetourneAAAAMMJJ(const aTime : TDateTime = 0.0) : string;
function RetourneChaineInstant(const aTime : TDateTime = 0.0; const aFormat : string = 'yyyymmdd') : string;
function RetourneStringLongueurFixe(
  aStr : string
  ; const aNbCar : integer
  ; const aCaractereMasque : char = '0'
  ; const aAligneGauche : boolean = False
  ) : string; overload;
function RetourneStringLongueurFixe(
  const aEntier : integer
  ; const aNbCar : integer
  ; const aCaractereMasque : char = '0'
  ; const aAligneGauche : boolean = False
  ) : string; overload;

function AssureExistenceDossier(const aDossier : string) : string;

implementation

uses SysUtils;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

function RemplaceOccurrences(aStr : string
    ; const aStrCherchee : string
    ; const aStrRemplacement : string
    ) : string;
var kPos : integer;
    kStr : string;
begin
    Result := '';
    kStr := aStr;
    kPos := Pos(aStrCherchee, kStr);
    while (kPos > 0) do
    begin
        Result := Result + Copy(kStr, 0, (kPos - 1)) + aStrRemplacement;
        kStr := Copy(kStr, kPos + length(aStrCherchee), length(kStr) - length(aStrCherchee));
        kPos := Pos(aStrCherchee, kStr);
    end;
    Result := Result + kStr;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

function RetourneAAAAMMJJ(const aTime : TDateTime) : string;
begin
  Result := RetourneChaineInstant(aTime, 'yyyymmdd');
end;

function RetourneChaineInstant(const aTime : TDateTime
                ; const aFormat : string) : string;
var kTime : TDateTime;
begin
  kTime := aTime;
  if (kTime <= 0.0) then
  begin
    kTime := Now();
  end;
  DateTimeToString(Result, 'yyyymmdd', kTime);
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

function RetourneStringLongueurFixe(
  aStr : string
  ; const aNbCar : integer
  ; const aCaractereMasque : char
  ; const aAligneGauche : boolean
  ) : string;
var
    kNb, kIndice : integer;
begin
  kNb := aNbCar - length(aStr);
  if (aCaractereMasque = ' ')
    and (aAligneGauche)
  then
  begin
    for kIndice := 0 to (kNb - 1) do
    begin
      aStr := aStr + aCaractereMasque;
    end;
  end else
  begin
    for kIndice := 0 to (kNb - 1) do
    begin
      aStr := aCaractereMasque + aStr;
    end;
  end;
  Result := aStr;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

function RetourneStringLongueurFixe(
  const aEntier : integer
  ; const aNbCar : integer
  ; const aCaractereMasque : char
  ; const aAligneGauche : boolean
  ) : string;
var
    kNb, kIndice : integer;
begin
  Result := '';
  kNb := aNbCar;
  if (aEntier < 0) then
  begin
    Result := '-';
  end else
  begin
    Result := '+';
  end;
  try
    Result := Result
      + RetourneStringLongueurFixe(
        IntToStr(ABS(aEntier))
        , kNb
        , aCaractereMasque
        , aAligneGauche
        )
      ;
  except
    for kIndice := 0 to (kNb - 1) do
    begin
      Result := Result + '9';
    end;
  end;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

function AssureExistenceDossier(const aDossier : string) : string;
begin
  Result := aDossier;
  if (aDossier <> '') then
  begin
    {$I-}
    if (not DirectoryExists(aDossier)) then
    begin
      if (not CreateDir(aDossier)) then
      begin
        Result := '';
      end;
    end;
    {$I+}
  end;
end;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

end.
